unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, ExtCtrls;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    sbKONIEC: TSpeedButton;
    sbMAKE_FILE: TSpeedButton;
    procedure sbMAKE_FILEClick(Sender: TObject);
    procedure sbKONIECClick(Sender: TObject);

  private
    procedure Copy_file();

  public

  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.sbKONIECClick(Sender: TObject);
begin
	Close();
end;

procedure TMainForm.sbMAKE_FILEClick(Sender: TObject);
begin
	Copy_file();
end;

procedure TMainForm.Copy_file();
var
   finp    : String;
   fout    : String;
	str_inp : TFileStream;
	str_out : TFileStream;

begin
	str_inp := Nil;
	str_out := Nil;

   finp := ExtractFilePath(Application.ExeName) + 'zrodlo.bmp';
	fout := ExtractFilePath(Application.ExeName) + 'cel.bmp';

   if not FileExists(finp) then
   begin
      ShowMessage('Brak pliku: ' + finp);
   	exit;
   end;

   try
      str_inp := TFileStream.Create(finp, fmOpenRead);
      str_out := TFileStream.Create(fout, fmCreate);

      str_out.CopyFrom(str_inp, str_inp.Size);

      ShowMessage('Kopiowanie pliku zakoczone!');
   finally
      FreeAndNIl(str_inp);
      FreeAndNIl(str_out);
   end;
end;

end.

